########################################################################
# options.tcl
#
#   Presents the options menu setting dialog.  These options are normally
#   saved in the .ini as well.
########################################################################

########################################################################
# optionsCheckDefaults() -	Check the defaults and light the Defaults
#                               button appropriately.
########################################################################
proc optionsCheckDefaults {} {
    global optionAutoProbe
    global optionSectorUpload
    global optionH8Swap
    global optionAutoLoad
    global optionAutoReset
    global optionGenericFile

    if { $optionAutoProbe == [iniGetDefaultAttribute "Program" "AutoProbe"] &&
         $optionSectorUpload == [iniGetDefaultAttribute "Program" "SectorUpload"] &&
         $optionH8Swap == [iniGetDefaultAttribute "Program" "H8Swap"] &&
         $optionAutoLoad == [iniGetDefaultAttribute "Program" "AutoLoad"] &&
         $optionAutoReset == [iniGetDefaultAttribute "Program" "AutoReset"] &&
         $optionGenericFile == [iniGetDefaultAttribute "Program" "GenericFile"] } {
	     .opts buttonconfigure defaults -state disable
    } else {
	     .opts buttonconfigure defaults -state normal
    }
}

########################################################################
# optionsDialogOptionCreate() -	Creates an individual option and packs
#                               it in using the given name.
########################################################################
proc optionsDialogOptionCreate {name variable wrap title text} {
    iwidgets::Labeledframe $name -labelpos nw -labeltext $title
    set option [$name childsite]

    checkbutton $option.button -highlightthickness 0 -anchor w -justify left \
	    -underline 0 -variable $variable -onvalue 1 -offvalue 0 \
	    -command { optionsCheckDefaults }

    message $option.text -highlightthickness 0 -width $wrap \
	    -text $text

    pack $option.button -side left -anchor n -padx 3 -pady 3
    pack $option.text -side left -anchor n -pady 3 -fill x

    bind $option <Button-1> [list $option.button invoke]
    bind $option.text <Button-1> [list $option.button invoke]
}

########################################################################
# optionsDialogActivate() -	Load and Activate the Options dialog.
########################################################################
proc optionsDialogActivate {} {
    global optionAutoProbe
    global optionSectorUpload
    global optionH8Swap
    global optionAutoLoad
    global optionAutoReset
    global optionGenericFile

    set optionAutoProbe [iniGetAttribute "Program" "AutoProbe"]
    set optionSectorUpload [iniGetAttribute "Program" "SectorUpload"]
    set optionH8Swap [iniGetAttribute "Program" "H8Swap"]
    set optionAutoLoad [iniGetAttribute "Program" "AutoLoad"]
    set optionAutoReset [iniGetAttribute "Program" "AutoReset"]
    set optionGenericFile [iniGetAttribute "Program" "GenericFile"]

    optionsCheckDefaults
    .opts activate
}

################################################################################
# optionsDialogCreate() - creates the Options dialog
################################################################################
proc optionsDialogCreate {} {
    global optionAutoProbe
    global optionSectorUpload
    global optionH8swap
    global optionAutoLoad
    global optionAutoReset
    global optionGenericFile
    global svdAutoLoad

    iwidgets::dialogshell .opts -title "Set Program Options"

    .opts add OK -text "OK" -command {
	iniSetAttribute "Program" "AutoProbe" $optionAutoProbe
	iniSetAttribute "Program" "SectorUpload" $optionSectorUpload
	iniSetAttribute "Program" "H8Swap" $optionH8Swap
	iniSetAttribute "Program" "AutoLoad" $optionAutoLoad
	iniSetAttribute "Program" "AutoReset" $optionAutoReset
	iniSetAttribute "Program" "GenericFile" $optionGenericFile

	set svdAutoLoad $optionAutoLoad

	.opts deactivate
    }
    .opts default OK
    .opts add defaults -text "Defaults" -command {
	set optionswin [.opts childsite]
	if { $optionAutoProbe != [iniGetDefaultAttribute "Program" "AutoProbe"] } {
	    [$optionswin.autoprobe childsite].button invoke
	}
	if { $optionSectorUpload != [iniGetDefaultAttribute "Program" "SectorUpload"] } {
	    [$optionswin.sectorupload childsite].button invoke
	}
	if { $optionH8Swap != [iniGetDefaultAttribute "Program" "H8Swap"] } {
	    [$optionswin.h8swap childsite].button invoke
	}
	if { $optionAutoLoad != [iniGetDefaultAttribute "Program" "AutoLoad"] } {
	    [$optionswin.autoload childsite].button invoke
	}
	if { $optionAutoReset != [iniGetDefaultAttribute "Program" "AutoReset"] } {
	    [$optionswin.autoreset childsite].button invoke
	}
	if { $optionGenericFile != [iniGetDefaultAttribute "Program" "GenericFile"] } {
	    [$optionswin.genericfile childsite].button invoke
	}
    }
    .opts add cancel -text "Cancel" -command { .opts deactivate }

    .opts add help -text "Help" -command { 
	tk_messageBox -default ok -icon info -title "Help" -type ok -message \
"In this window, you set the options
that control many different aspects of
the program.  Each option is explained
next to the option." }

    .opts configure -modality application

    set optionswin [.opts childsite]

    set wrap 400

    optionsDialogOptionCreate $optionswin.autoprobe optionAutoProbe $wrap "Auto Probe Serial Ports" \
	    "This options applies to Windows only.  If this option is turned on,\
	     this program will automatically probe for usable serial ports."

    optionsDialogOptionCreate $optionswin.sectorupload optionSectorUpload $wrap "Upload Sector-by-Sector" \
	    "Checking this box turns on sector-by-sector upload.\
	     Normally upload is done track-by-track.\
	     If upload errors are occurring in track-by-track, then try this."

    optionsDialogOptionCreate $optionswin.h8swap optionH8Swap $wrap "H8/89 Floppy Swap" \
	    "This option (when checked) swaps the order of the\
	     floppy drives so that working with the H8/89 is easier.\
	     This option only has effect when the \"Floppy Type\" is set to H8/H89.\
	     Note that the lights on the physical SVD will still be reversed."

    optionsDialogOptionCreate $optionswin.autoload optionAutoLoad $wrap "Auto Download" \
	    "This option causes a download to start automatically after\
	     you \"Load...\" a floppy image.\
	     This option is also settable on the main screen."

    optionsDialogOptionCreate $optionswin.autoreset optionAutoReset $wrap "Auto Reset" \
	    "This option will attempt to reset SVD every time\
	     a change in the serial port settings is done.\
	     A reset is the only way in which the SVD can match the serial\
	     port speed settings of the PC (currently)."

#
# GENERIC OPTION TURNED OFF FOR NOW
#
#    optionsDialogOptionCreate $optionswin.genericfile optionGenericFile $wrap "Auto Generic File Formats" \
#	    "This option will apply a \"generic\" guessing algorithm for file\
#	     types that are not otherwise recognized.\
#	     This algorithm takes advantage of the floppy type that has been\
#	     chosen, and will only attempt generic guessing for that type.\
#	     If this option is off, more files will probably come back as an \"UNKNOWN\" format."

# Pack all of the options together

    pack $optionswin.autoprobe -side top -anchor nw -fill x
    pack $optionswin.sectorupload -side top -anchor nw -fill x
    pack $optionswin.h8swap -side top -anchor nw -fill x
    pack $optionswin.autoload -side top -anchor nw -fill x
    pack $optionswin.autoreset -side top -anchor nw -fill x
#    pack $optionswin.genericfile -side top -anchor nw -fill x

}
